/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.ar;

import com.ibm.hwmca.base.pa.event.SecondaryAnalysisCompleteEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.pa.incident.IncidentPool;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.ar.CommonServiceAnalysisRoutine;
import com.ibm.hwmca.xfw.pa.event.CommonServiceAREvent;
import com.ibm.hwmca.xfw.pa.event.CommonServiceEvent;
import com.ibm.hwmca.xfw.pa.event.PooledEvent;
import com.ibm.hwmca.xfw.pa.incident.CommonServiceIncident;
import java.util.HashSet;
import java.util.Iterator;

public class SecondaryAnalysisRoutine
extends CommonServiceAnalysisRoutine
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "XPASCART";
    private static final String TRACE_MASKF = "XPASCARF";
    private static final String TRACE_MASKD = "XPASCARD";
    private static final boolean UNIT_TEST = true;

    public SecondaryAnalysisRoutine() {
        Trace.trace(TRACE_MASKF, "<-> ctor");
    }

    public void analyze(ProblemAnalysisEvent event) {
        Trace.trace(TRACE_MASKD, "--> analyze()");
        CommonServiceAREvent ourEvent = (CommonServiceAREvent)event;
        PASystem system = ourEvent.getSystem();
        String poolId = ourEvent.getIncidentPoolId();
        IncidentPool analysisPool = SecondaryAnalysisRoutine.getAnalyzingIncidentPool(poolId);
        Iterator poolIt = analysisPool.iterator();
        HashSet<CommonServiceEvent> eventSet = new HashSet<CommonServiceEvent>();
        while (poolIt.hasNext()) {
            CommonServiceIncident anIncident = (CommonServiceIncident)poolIt.next();
            CommonServiceEvent secondaryEvent = anIncident.getSecondaryEvent();
            if (secondaryEvent == null || eventSet.contains(secondaryEvent)) continue;
            Trace.trace(TRACE_MASKD, "posting secondary event: " + secondaryEvent);
            secondaryEvent.setSystem(system);
            if (secondaryEvent instanceof PooledEvent) {
                ((PooledEvent)((Object)secondaryEvent)).setIncidentPoolId(poolId);
                if (ourEvent instanceof PooledEvent) {
                    ((PooledEvent)((Object)secondaryEvent)).setIncident(ourEvent.getIncident());
                }
            }
            this.eventManager.handleEvent(secondaryEvent);
            eventSet.add(secondaryEvent);
        }
        Trace.trace(TRACE_MASKD, "post a SecondaryAnalysisCompleteEvent");
        this.postServiceAREvent(new SecondaryAnalysisCompleteEvent(this), system, poolId);
        Trace.trace(TRACE_MASKD, "<-- analyze()");
    }
}

